package presentation.graph;

/**
 * @author Alberto Iachini
 */

import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;


public class StateCellViewFactory extends DefaultCellViewFactory {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 8942782048265983296L;

	public CellView createView(GraphModel model, Object cell) {
		CellView view = null;
		if (model.isPort(cell))
			view = createPortView(cell);
		else if (model.isEdge(cell))
			view = createEdgeView(cell);
		else
			view = createVertexView(cell);
		return view;
	}
	
	protected VertexView createVertexView(Object cell) {
		if(cell instanceof FinalStateVertex)
			return new FinalStateVertexView(cell);
		else
			return new StateVertexView(cell);
		
	}

}
